#include "signals.h"

#include <saas/library/daemon_base/unistat_signals/signals_ut_helpers.h>
#include <saas/indexerproxy/configs/config.h>

#include <library/cpp/testing/unittest/registar.h>

namespace {
    const TString TestService("test_service_name");
    const TSet<TString> TestServiceSet( { TestService} );
    TProxyServicesConfig TestProxyConfig;
}

Y_UNIT_TEST_SUITE(RtyServerUnistatSignalsSuite) {
    Y_UNIT_TEST(TestInit) {
        ClearSignals();
        TSaasIndexerProxySignals::BuildSignals(TestServiceSet, TestProxyConfig);
        PrintSignals();
    }
    Y_UNIT_TEST(TestSuccessRecord) {
        ClearSignals();
        TSaasIndexerProxySignals::BuildSignals(TestServiceSet, TestProxyConfig);
        TSaasIndexerProxySignals::TUnistatRecordContext context(TestService, 200, 100, 3000, false, false, "", false, {});
        TSaasIndexerProxySignals::DoUnistatRecord(context);
        PrintSignals();
    }
    Y_UNIT_TEST(TestFailureRecord) {
        ClearSignals();
        TSaasIndexerProxySignals::BuildSignals(TestServiceSet, TestProxyConfig);
        TSaasIndexerProxySignals::TUnistatRecordContext context(TestService, 500, 100, 3000, false, false, "", false, {});
        TSaasIndexerProxySignals::DoUnistatRecord(context);
        PrintSignals();
    }
}
