#pragma once

#include <util/generic/string.h>

namespace NSaas {

class TAuthorization {
public:
    TAuthorization(const TString& salt);
public:
    TString GetAuthCookie(const TString& service, ui64 prefix) const;
    bool CheckAuthorization(const TString& authCookie, const TString& service, ui64 prefix) const {
        return authCookie == GetAuthCookie(service, prefix);
    }
private:
    TString KeyWord;
};

}
