#pragma once

#include <saas/protos/reply.pb.h>
#include <saas/protos/rtyserver.pb.h>

#include <util/generic/string.h>
#include <util/generic/vector.h>

struct TRTYStatusBehaviour {
    NRTYServer::TReply::TRTYStatus ReplyType;
    NRTYServer::TReply::TDispStatus DispReplyType;
    TString Name;
    bool IsFinalStatus;
    bool IsAsyncStatus;
    bool IsTolerable;
    bool NeedInResend;
};

struct TDispStatusBehaviour {
    NRTYServer::TReply::TDispStatus ReplyType;
    TString Name;
    ui32 HttpCode;
    bool NeedInFullDelivered;
    bool IsAsyncCode;
    bool IgnoreInMerge;
};

struct TRTYMessageBehaviour {
    NRTYServer::TMessage::TMessageType MessageType;
    TString Name;
    bool IsContentMessage;
    bool IsBroadcastMessage;
    bool IsModification;
    bool IsAsync;
    bool IsRequestProcessor;
    bool IsPrefixOmitted;
    bool IsDuplicatable;
    bool IsPureDeletion;
    bool IdentifyByContent;
};

NRTYServer::TReply::TDispStatus DecodeHttpToDisp(ui32 httpCode);
const TDispStatusBehaviour* GetDispBehaviour(ui32 httpCode);
const TRTYMessageBehaviour& GetBehaviour(const NRTYServer::TMessage::TMessageType& message);
const TRTYMessageBehaviour* GetBehaviour(const TString& name);
bool IsAsyncMessage(const NRTYServer::TMessage& message);
const TDispStatusBehaviour& GetBehaviour(const NRTYServer::TReply::TDispStatus& status);
const TRTYStatusBehaviour& GetBehaviour(const NRTYServer::TReply::TRTYStatus& status);
bool IsQueryProcessorMessage(const NRTYServer::TMessage::TMessageType& type, const TString& queryDel);
bool IsQueryProcessorMessage(const NRTYServer::TMessage::TMessageType& type, const NRTYServer::TMessage::TDocument& doc);
TVector<ui32> GetDispCodes();
