#pragma once

#include <saas/protos/compressed_data.pb.h>
#include <library/cpp/blockcodecs/codecs.h>

inline TString ExtractDecompressedData(NRTYServer::TCompressedDataContainer& compressedDataContainer) {
    Y_ENSURE(compressedDataContainer.GetAlgorithm() == NRTYServer::TCompressedDataContainer_TCompressionAlgorithm_ZSTD_10);

    auto codec = NBlockCodecs::Codec("zstd_10");
    Y_ENSURE(codec);
    
    TString protoDataString = codec -> Decode(compressedDataContainer.GetData());

    return protoDataString;
}
