#pragma once
#include <library/cpp/yconf/conf.h>
#include <saas/protos/rtyserver.pb.h>

namespace NSaas {
    struct TMessageLimits {
        static const ui32 MAX_MESSAGE_SIZE_BYTES;
        static const ui32 MAX_URL_SIZE;
    };

    enum class EKeyPrefixCheckType {
        any,
        zero,
        non_zero
    };

    class TMessageChecker;

    class TCheckMessageSettings {
    private:
        bool Disabled = false;
        ui32 CheckMaxSizeBytes = TMessageLimits::MAX_MESSAGE_SIZE_BYTES;  // 0 means disabled check
        bool CheckAttributes = true;
        EKeyPrefixCheckType KeyPrefixCheckType = EKeyPrefixCheckType::non_zero;

    public:
        void Init(const TYandexConfig::Section& section);
        void ToString(IOutputStream& so) const;

        TCheckMessageSettings& SetDisabled(bool value);
        TCheckMessageSettings& SetCheckMaxSizeBytes(ui32 bytes);
        TCheckMessageSettings& SetCheckAttributes(bool value);
        TCheckMessageSettings& SetKeyPrefixCheckType(EKeyPrefixCheckType value);

        bool GetDisabled() const;
        ui32 GetCheckMaxSizeBytes() const;
        bool GetCheckAttributes() const;
        EKeyPrefixCheckType GetKeyPrefixCheckType() const;
    };

    class TMessageChecker {
    public:
        TMessageChecker(const TCheckMessageSettings& settings = TCheckMessageSettings());
        bool Check(const NRTYServer::TMessage& message) const;
        bool Check(const NRTYServer::TMessage& message, TString& error) const noexcept;

    protected:
        TCheckMessageSettings Settings;
    };
}
