#include "action.h"

#include <library/cpp/json/writer/json_value.h>
#include <util/stream/str.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/logger/global/global.h>

namespace NDaemonController {
    NJson::TJsonValue TGetConfAction::DoSerializeToJson() const {
        NJson::TJsonValue result;
        Data.Serialize(result);
        return result;
    }

    void TGetConfAction::DoDeserializeFromJson(const NJson::TJsonValue& json) {
        Data = TListConfAction::TConfigFile(json);
    }

    TGetConfAction::TFactory::TRegistrator<TGetConfAction> TGetConfAction::Registrator(GET_CONF_ACTION_NAME);
}
