#pragma once
#include <saas/library/daemon_base/actions_engine/list_conf/action.h>

#define GET_CONF_ACTION_NAME "GET_CONF"

namespace NDaemonController {

    class TGetConfAction : public TAction {
    private:
        TListConfAction::TConfigFile Data;
        TDuration Timeout;
        ui32 AttemptionsMaxResend;

    protected:
        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        static TFactory::TRegistrator<TGetConfAction> Registrator;
    public:
        TGetConfAction() {}
        TGetConfAction(const TListConfAction::TConfigFile& data, const TDuration& timeout, const ui32 attemptionsMaxResend)
            : Data(data)
            , Timeout(timeout)
            , AttemptionsMaxResend(attemptionsMaxResend)
        {}

        virtual TString GetCustomUri() const override {
            return "get_conf";
        }

        virtual TString DoBuildCommand() const override {
            return "filename=" + Data.Url;
        }

        virtual void DoInterpretResult(const TString& result) override {
            Data.Content = result;
            Success("");
        }

        virtual TDuration GetTimeoutDuration() const override {
            return Timeout;
        }

        virtual TString ActionName() const override { return GET_CONF_ACTION_NAME; }

        const TListConfAction::TConfigFile& GetData() const {
            return Data;
        }

        virtual ui32 GetAttemptionsMaxResend() const override{
            return AttemptionsMaxResend;
        }
    };
}
