#pragma once
#include <saas/library/daemon_base/actions_engine/controller_client.h>
#include <util/generic/vector.h>
#include <saas/library/sharding/sharding.h>

#define LIST_CONF_ACTION_NAME "LIST_CONF"

namespace NDaemonController {

    class TListConfAction : public TAction {
    public:
        struct TConfigFile {
            TConfigFile();
            TConfigFile(const NJson::TJsonValue& json);
            void Serialize(NJson::TJsonValue& json) const;
            TString Name;
            TString Url;
            TString Content;
            i32 Version {-1};
        };

        typedef TVector<TConfigFile> TConfigFiles;

        TListConfAction()
        {}

        TListConfAction(const TString& slot, const TString& service, const TString& serviceType, const TString& ctype, const ui32 attemptionsMaxResend, const TString& version = "CURRENT"
                , const NSaas::TSlotInfo* fullSlotInfo = nullptr, const TDuration& timeout = TDuration::Seconds(1), const TString& tags = "")
            : Slot(slot)
            , Service(service)
            , ServiceType(serviceType)
            , CType(ctype)
            , AttemptionsMaxResend(attemptionsMaxResend)
            , Version(version)
            , Tags(tags)
            , Timeout(timeout)
        {
            if (fullSlotInfo)
                FullSlotInfo = MakeHolder<NSaas::TSlotInfo>(*fullSlotInfo);
        }

        virtual TString GetCustomUri() const override {
            return "list_conf";
        }

        virtual TString DoBuildCommand() const override {
            if (FullSlotInfo)
                return "slot_info=" + FullSlotInfo->SerializeToJson().GetStringRobust();
            return "slot=" + Slot
                  + "&service_type=" + ServiceType
                  + "&ctype=" + CType
                  + "&service=" + Service
                  + "&version=" + Version
                  + "&tags=" + Tags;
        }

        virtual TDuration GetTimeoutDuration() const override {
            return Timeout;
        }

        virtual void DoInterpretResult(const TString& result) override;
        virtual TString ActionName() const override { return LIST_CONF_ACTION_NAME; }
        TConfigFiles& GetFileList() {
            return Result;
        }

        const NSaas::TSlotInfo* GetSlotInfoResult() const {
            if (!!SlotInfoResult) {
                return SlotInfoResult.Get();
            } else {
                return nullptr;
            }
        }

        virtual ui32 GetAttemptionsMaxResend() const override{
            return AttemptionsMaxResend;
        }

    protected:
        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        static TFactory::TRegistrator<TListConfAction> Registrator;

    private:
        TString Slot;
        TString Service;
        TString ServiceType;
        TString CType;
        ui32 AttemptionsMaxResend;
        TString Version;
        TString Tags;
        TConfigFiles Result;
        THolder<NSaas::TSlotInfo> SlotInfoResult;
        TDuration Timeout;
        THolder<NSaas::TSlotInfo> FullSlotInfo;
    };
}
