#include "common.h"
#include <util/stream/output.h>
#include <util/string/cast.h>
#include <library/cpp/logger/global/global.h>

template <>
void Out<NController::TServerStatusByController>(IOutputStream& output, TTypeTraits<NController::TServerStatusByController>::TFuncParam type) {
    switch (type) {
    case NController::ssbcActive:
        output << "Active";
        break;
    case NController::ssbcNotRunnable:
        output << "NotRunnable";
        break;
    case NController::ssbcStopping:
        output << "Stopping";
        break;
    case NController::ssbcStarting:
        output << "Starting";
        break;
    case NController::ssbcStopped:
        output << "Stopped";
        break;
    default:
        FAIL_LOG("Incorrect type %d", (ui32)type);
    }
}

template <>
NController::TServerStatusByController FromStringImpl<NController::TServerStatusByController>(const char* data, size_t length) {
    if (strcmp(data, "Active") == 0)
        return NController::ssbcActive;
    if (strcmp(data, "Starting") == 0)
        return NController::ssbcStarting;
    if (strcmp(data, "Stopped") == 0)
        return NController::ssbcStopped;
    if (strcmp(data, "Stopping") == 0)
        return NController::ssbcStopping;
    if (strcmp(data, "NotRunnable") == 0)
        return NController::ssbcNotRunnable;
    ythrow yexception() << "cannot parse TServerStatusByController from string " << TString(data, length);
}
