#pragma once

#include "patcher.h"

#include <library/cpp/getopt/last_getopt.h>

class TDaemonOptions {
public:
    TDaemonOptions(bool validateOnly = false)
        : ValidateOnly(validateOnly)
    {}
    void Parse(int argc, char* argv[]);
    void BindToOpts(NLastGetopt::TOpts& opts);

    TString RunPreprocessor() {
        return Preprocessor.ReadAndProcess(ConfigFileName);
    }
    TDaemonConfigPatcher& GetPreprocessor() {
        return Preprocessor;
    }
    bool GetValidateOnly() const {
        return ValidateOnly;
    }
    const TString& GetConfigFileName() const {
        return ConfigFileName;
    }
    void SetConfigFileName(const TString& configFileName) {
        ConfigFileName = configFileName;
    }
private:
    TDaemonConfigPatcher Preprocessor;
    bool ValidateOnly;
    TString ConfigFileName;
};
