#include "patcher.h"

#include <saas/util/system/environment.h>

#include <util/digest/murmur.h>
#include <util/folder/path.h>
#include <util/string/cast.h>
#include <util/system/execpath.h>
#include <util/system/hostname.h>
#include <util/system/info.h>

TDaemonConfigPatcher::TDaemonConfigPatcher(const TString& patchPrefix /*= ""*/)
    : TConfigPatcher(patchPrefix)
{
    const TString& host = HostName();

    // add several system variables
    SetVariable("NCPU", ToString(NSystemInfo::CachedNumberOfCpus()));
    SetVariable("PAGESIZE", ToString(NSystemInfo::GetPageSize()));
    SetVariable("_BIN_DIRECTORY", TFsPath(GetExecPath()).Dirname());
    SetVariable("HOSTNAME", host);
    SetVariable("HOSTNAME_HASH", ToString(MurmurHash<ui32>(host.data(), host.size())));

    // set environment variables
    for (auto&& variable : NUtil::GetEnvironmentVariables()) {
        SetVariable(variable.first, variable.second);
    }
}
