#pragma once

#include <library/cpp/yconf/conf.h>

namespace NThreading {
class TPoolOpts;

class TThreadingConfig {
private:
    class TImpl;

    TString PresetName;
    THolder<TImpl> Impl;

public:
    TThreadingConfig();
    TThreadingConfig(const TThreadingConfig& other);
    TThreadingConfig& operator=(const TThreadingConfig& other);

    virtual ~TThreadingConfig();

    virtual void Init(const TYandexConfig::Directives& directives);
    virtual void ToString(TStringStream& so) const;

    inline const TString& GetPresetName() const {
        return PresetName;
    }

    const TPoolOpts* GetPoolOpts(const TString& loadType) const;

public:
    static TPoolOpts ParsePoolOpts(const TString& strOpts);
};

} // NThreading
