#pragma once
#include "async_controller_action.h"
#include <saas/library/daemon_base/actions_engine/controller_script.h>

#define EXECUTE_SCRIPT_ACTION_NAME "EXECUTE_SCRIPT"

namespace NDaemonController {

    class TExecuteScriptAction : public TControllerAsyncAction {
    private:
        NRTYScript::TRTYClusterScript Script;
    protected:

        virtual NJson::TJsonValue DoSerializeToJson() const override;
        virtual void DoDeserializeFromJson(const NJson::TJsonValue& json) override;

        virtual TString DoBuildCommandStart() const override {
            return "command=execute_script&async=yes&script_name=" + ActionName();
        }

        virtual void InterpretTaskReply(TAsyncTaskExecutor::TTask::TStatus taskStatus, const NJson::TJsonValue& result) override;

        static TFactory::TRegistrator<TExecuteScriptAction> Registrator;
    public:

        TExecuteScriptAction()
        {
        }

        TExecuteScriptAction(TAsyncPolicy policy)
            : TControllerAsyncAction(policy)
        {
        }

        TExecuteScriptAction(const TString& waitActionName)
            : TControllerAsyncAction(waitActionName)
        {}

        virtual TLockType GetLockType() const override {
            return ltWriteLock;
        }

        virtual bool GetNotContinuableTaskOnStarting() const override {
            return false;
        }

        virtual bool GetPostContentStart(TString& result) const override;

        NRTYScript::TRTYClusterScript& GetScript() {
            return Script;
        }

        virtual TString ActionName() const override { return EXECUTE_SCRIPT_ACTION_NAME; }
    };
}
