#pragma once

#include <library/cpp/json/json_value.h>

#include <util/generic/string.h>
#include <util/generic/map.h>
#include <util/generic/ptr.h>
#include <util/string/cast.h>

class TCollectServerInfo;

struct TServerInfo : public NJson::TJsonValue {
    template <class T>
    inline TServerInfo& operator() (const TString& name, const T& value) {
        InsertValue(name, value);
        return *this;
    }

    template <class K, class V>
    inline TServerInfo& operator() (const TString& name, const TMap<K, V>& valueMap) {
        if (!valueMap.empty()) {
            NJson::TJsonValue& jsonMap = InsertValue(name, NJson::JSON_MAP);
            for (auto [key, value]: valueMap) {
                jsonMap.InsertValue(ToString(key), value);
            }

        }
        return *this;
    }
};

namespace NSaasServerInfo {
    TString GetInstanceTags(bool onlyWhiteList);
    TString GetLabelVars(bool onlyWhiteList);
    TString GetNannyService();
    TString GetPseudoTagsString();
}

TServerInfo CollectServerInfo(TCollectServerInfo& collector);
