#pragma once

#include "info.h"

#include <saas/util/system/dir_digest.h>

#include <library/cpp/mediator/messenger.h>
#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/stream/output.h>
#include <util/string/printf.h>

class TCollectServerInfo: public IMessage {
private:
    TMap<TString, NJson::TJsonValue> AdditionalInfo;

protected:
    bool IsHumanReadable;

public:
    explicit TCollectServerInfo(bool isHumanReadable)
        : IsHumanReadable(isHumanReadable)
    {}

    NJson::TJsonValue& MutableAdditionalInfo(const TString& name) {
        return AdditionalInfo[name];
    }

    virtual void Fill(TServerInfo& info) {
        for (const auto& field : Fields)
            info.InsertValue(field.first, field.second);

        for (auto&& i : AdditionalInfo) {
            info(i.first, i.second);
        }
    }

    TMap<TString, NJson::TJsonValue> Fields;
};

struct TUpdateConfigHash : IMessage {
    const TString Path;
    const TFileHashInfo Info;

    TUpdateConfigHash(TString path, TFileHashInfo info)
        : Path(std::move(path))
        , Info(std::move(info))
    {
    }
};
