#pragma once

#include "module.h"
#include <saas/library/daemon_base/config/daemon_config.h>
#include <library/cpp/mediator/messenger.h>
#include <util/generic/vector.h>
#include <util/generic/ptr.h>

#define MESSAGE_PROCESSORS_MODULE_NAME "MessageProcessors"
class TDaemonConfig;

namespace NRTY {

    class TMessageProcessorsModule: public IDaemonModule {
    private:
        const TDaemonConfig& Config;
        TVector<TAtomicSharedPtr<IMessageProcessor>> Processors;
        static IDaemonModule::TFactory::TRegistrator<TMessageProcessorsModule> Registrator;
    public:

        typedef NObjectFactory::TParametrizedObjectFactory<IMessageProcessor, TString, TString> TProcessorsFactory;

        TMessageProcessorsModule(const TDaemonConfig& config)
            : Config(config)
        {
            for (auto i : Config.GetSpecialMessageProcessors()) {
                IMessageProcessor* product = TProcessorsFactory::Construct(i.first, i.second);
                CHECK_WITH_LOG(!!product);
                Processors.push_back(product);
            }
        }

        virtual ~TMessageProcessorsModule() override {}

        virtual bool Start(const TStartContext& /*startContext*/) override {
            for (auto i : Processors)
                RegisterGlobalMessageProcessor(i.Get());
            return true;
        }

        virtual bool Stop(const TStopContext& /*stopContext*/) override {
            for (auto i : Processors)
                UnregisterGlobalMessageProcessor(i.Get());
            return true;
        }

        virtual TString Name() const override {
            return MESSAGE_PROCESSORS_MODULE_NAME;
        }
    };

}
