#pragma once
#include <saas/util/smartqueue_ng.h>
#include <util/generic/vector.h>

//
// Class for realtime options tuning
//
class TRTYPoolsControl final  {
public:
    using TUpdatableRef = NUtil::TSmartMtpQueueNg::TUpdatableRef;
    using TOptions = NUtil::TSmartMtpQueueNg::TOptions;

    struct TUpdater {
        TString Name;
        TUpdatableRef Handle;
    };

private:
    TVector<TUpdater> Updaters;
    TMutex Mutex;

private:
    void Purge();

public:
    TRTYPoolsControl();
    virtual ~TRTYPoolsControl();

    void Add(const TString& name, TUpdatableRef& handle);
    bool Update(const TString& name, const TOptions& opts);
};


