#pragma once

#include <saas/library/daemon_base/protos/threading.pb.h> // PeerDir is not needed
#include <util/generic/map.h>
#include <util/generic/ptr.h>

class IThreadFactory;
class IThreadPool;
namespace NThreading {
    class TThreadingConfig;
}

class TRTYPools final {
public:
    using TLoadtype = NThreading::TLoadtype;

public:
    IThreadFactory* Get(TLoadtype loadtype);
    IThreadPool* CreateThreadPool(TLoadtype loadtype, IThreadFactory* pool /*=nullptr*/, size_t threadCount, size_t maxQueueSize, const TString& threadName); // = {} TODO

public:
    TRTYPools();
    ~TRTYPools();
    void Initialize(const NThreading::TThreadingConfig& config);
    void Destroy();

private:
    class TImpl;
    THolder<TImpl> Impl_;
};
