#pragma once

#include <library/cpp/unistat/unistat.h>
#include <search/common_signals/signals.h>

#include <util/generic/strbuf.h>
#include <util/generic/map.h>

class TSaasUnistatSignals : public NSearch::TCommonSearchSignals {
public:
    static NUnistat::TPriority Prio(TStringBuf code = TStringBuf(), bool isService = false, bool isExtraInfo = false);

    static TMaybe<double> GetFloatSignalValue(TUnistat& inst, TStringBuf signal);

    static void PushSignal(TUnistat& inst, TStringBuf signal, double value);
    static void PushSignalWithCode(TUnistat& inst, TStringBuf signal, TStringBuf code, TStringBuf xxCode);

    inline static void PushGlobalSignal(TStringBuf signal, double value) {
        PushSignal(TUnistat::Instance(), signal, value);
    }
    inline static void PushGlobalSignalWithCode(TStringBuf signal, TStringBuf code, TStringBuf xxCode) {
        PushSignalWithCode(TUnistat::Instance(), signal, code, xxCode);
    }

    inline static void PushGlobalSignal(std::initializer_list<TStringBuf> signals, double value) {
        for (auto&& signal : signals) {
            PushGlobalSignal(signal, value);
        }
    }

    inline static void PushGlobalSignalWithCode(std::initializer_list<TStringBuf> signals, TStringBuf code, TStringBuf xxCode) {
        for (auto&& signal : signals) {
            PushGlobalSignalWithCode(signal, code, xxCode);
        }
    }
};

class TSaasProxyUnistatSignals : public TSaasUnistatSignals {
public:
    virtual void AddCode(const int code);
    virtual void AddService(TString service);

protected:
    TSet<TString> Services;
    TSet<TString> Codes;
};

void ReportUnistatSignals(IOutputStream& output, int level = 0);
