#include "signals.h"
#include "signals_ut_helpers.h"

#include <library/cpp/testing/unittest/registar.h>

namespace {
    static const TVector<double> Intervals{0, 1, 2};

    class TTestSignals : public TSaasUnistatSignals {

    public:
        void Init(TUnistat &t) const override {
            t.DrillFloatHole("debug-errors-CTYPE", "dmmm", Prio());
            t.DrillFloatHole("test-float-hole", "dmmm", Prio());
            t.DrillHistogramHole("test-histogram-hole", "dhhh", Prio(), Intervals);
        }
        static void Build() {
            TTestSignals signals;
            signals.Init(TUnistat::Instance());
        }
    };
}

Y_UNIT_TEST_SUITE(RtyServerUnistatSignalsSuite) {
    Y_UNIT_TEST(TestEmpty) {
        ClearSignals();
        PrintSignals();
    }
    Y_UNIT_TEST(TestDefault) {
        ClearSignals();
        TTestSignals::Build();
        PrintSignals();
    }
    Y_UNIT_TEST(TestPushFloat) {
        ClearSignals();
        TTestSignals::Build();
        TSaasUnistatSignals::PushGlobalSignal(TString("test-float-hole"), 1);
        PrintSignals();
    }
    Y_UNIT_TEST(TestPushHistogram0) {
        ClearSignals();
        TTestSignals::Build();
        TSaasUnistatSignals::PushGlobalSignal(TString("test-histogram-hole"), 0.5f);
        PrintSignals();
    }
    Y_UNIT_TEST(TestPushHistogram1) {
        ClearSignals();
        TTestSignals::Build();
        TSaasUnistatSignals::PushGlobalSignal(TString("test-histogram-hole"), 1.5f);
        PrintSignals();
    }
    Y_UNIT_TEST(TestPushHistogram2) {
        ClearSignals();
        TTestSignals::Build();
        TSaasUnistatSignals::PushGlobalSignal(TString("test-histogram-hole"), 1000.0f);
        PrintSignals();
    }
    Y_UNIT_TEST(TestNoSuchHole) {
        ClearSignals();
        TTestSignals::Build();
        TSaasUnistatSignals::PushGlobalSignal(TString("invalid"), 1);
        PrintSignals();
    }
}
