#pragma once

#include "signals.h"

#include <library/cpp/json/json_prettifier.h>

#include <util/generic/strbuf.h>
#include <util/stream/output.h>
#include <util/string/cast.h>
#include <util/system/env.h>

namespace {
    void PrintSignals() {
        static const bool printSignals = (GetEnv("PRINT_SIGNALS") == "1");
        static const int level = FromString<int>(GetEnv("PRINT_SIGNALS_LEVEL", "0"));
        if (printSignals) {
            TStringStream ss;
            ReportUnistatSignals(ss, level);

            auto prettifier = NJson::TJsonPrettifier::Prettifier(false, 2);
            prettifier.MaxPaddingLevel = 1;
            prettifier.Prettify(ss.Str(), Cout);
            Cout << Endl;
        }
    }

    void ClearSignals() {
        TUnistat::Instance().Reset();
    }
}
