#pragma once

#include <saas/protos/rtyserver.pb.h>
#include <saas/library/erasure/protos/erasure.pb.h>

#include <util/string/vector.h>
#include <util/generic/buffer.h>
#include <util/generic/fwd.h>
#include <util/generic/string.h>

namespace NSaas {
    class TErasureHelper {
    public:
        TErasureHelper() = default;
        TErasureHelper(ui32 mainNumber, ui32 parityNumber) : MainNumber(mainNumber), ParityNumber(parityNumber) {}

        // Returns MainNumber(splitted parts) + ParityNumber(encoded with help of JErasure)
        TVector<NSaas::TErasurePart> SplitToParts(TStringBuf object) const;

        // General merger
        TString Merge(const TVector<NSaas::TErasurePart>& parts) const;

    private:
        // Extract pointers to data from parts
        TVector<char *> GetDataStartsPtrs(TVector<NSaas::TErasurePart>& parts) const;

        // Believes that first MainNumber parts are Main and checks its validity
        bool MainPartsAreCorrect(const TVector<NSaas::TErasurePart>& parts) const;

        // Method believes that every part is correct main part
        TString MergeFromMainParts(const TVector<NSaas::TErasurePart>& parts) const;

    private:
        ui32 MainNumber = 3;
        ui32 ParityNumber = 2;
    };
}

