#include "hash_to_block_mode.h"

#include <library/cpp/digest/md5/md5.h>

#include <contrib/restricted/cityhash-1.0.2/city.h>

ui64 TBlockHash::GetBlockKey(const TString& kps, const TString& url) const {
    TString key = kps + "#" + url;
    return CityHash_v1_0_2::CityHash64(key.data(), key.size()) / countHashPart;
}

TString TBlockHash::GetGtaKey(const TString& kps, const TString& url) const {
    return MD5::Calc(kps + "#" + url);
}
