#pragma once

#include <util/generic/fwd.h>
#include <util/generic/ylimits.h>
#include <util/system/types.h>

class TBlockHash {
    ui64 countHashPart;

public:
    TBlockHash(const ui64& blockCount) {
        countHashPart = Max<ui64>() / blockCount;
    }

    ui64 GetBlockKey(const TString& kps, const TString& url) const;

    TString GetGtaKey(const TString& kps, const TString& url) const;
};
