#pragma once

#include "doc_hash.h"

namespace NSaas {
    template<class TId>
    struct IDocHashIteratorT {
        virtual ~IDocHashIteratorT() = default;
        virtual bool IsValid() const = 0;
        virtual void Next() = 0;
        virtual std::pair<TDocHash, TId> GetHashWithId() const = 0;
    };

    using IDocHashIterator = IDocHashIteratorT<ui32>;
}

