#pragma once

#include <library/cpp/http/server/http.h>

class THttpMultiServer {
public:
    using ICallBack = THttpServer::ICallBack;
    using TOptions = THttpServer::TOptions;

public:
    THttpMultiServer(ICallBack* cb, const TOptions& options = TOptions(), size_t servers = 1);
    ~THttpMultiServer();

    void Start();
    void Stop();
    void ShutdownAndWait();

    bool IsRunning() const;

private:
    class TImpl;
    THolder<TImpl> const Impl;
};
