#pragma once

#include <saas/library/index_snapshot/base/snapshot_manager.h>
#include <mapreduce/yt/interface/fwd.h>

namespace NSaas {
    void PublishYtSnapshot(NYT::IClientBase&, const TString& pubDir, const IIndexSnapshotManager::TSnapshot& snapshot);

    IIndexSnapshotManager::TSnapshots GetYtSnapshots(NYT::IClientBase&, const TString& pubDir, const std::function<bool(TInstant)>& filter, const IStopCondition& stopper = IStopCondition::NonStop());

    // Copy a YT data blob to the different location on the same YT cluster
    // and patch the blob's snapshot accordingly
    IIndexSnapshotManager::TSnapshot CopyDataBlobAndPatchSnapshot(NYT::IClientBase& yt,
        const IIndexSnapshotManager::TSnapshot& snapshot, const TString& oldDataDir, const TString& newDataDir);
}
