#pragma once
#include "abstract.h"

#include <util/generic/maybe.h>

class IReplier: public IRTYReplierAbstract {
public:
    typedef TAtomicSharedPtr<IReplier> TPtr;

protected:
    ui64 MessageId;
    NRTYServer::TReply::TRTYStatus Status;
    TString ErrorMessage;
    TInstant Created;

protected:
    virtual bool DoReply() = 0;
    virtual void LogReply(const ui64 messageId, const TString& status, const ui32 httpCode, const ui64 duration, const TString& errorMessage) = 0;

public:
    NRTYServer::TReply BuildRTYReply() const;

    IReplier(ITransaction& transaction, ui64 messageId, const TInstant& constructionTime = Now());

    virtual ~IReplier() override {
    }

    virtual void SetStatus(NRTYServer::TReply::TRTYStatus status, const TString& errorMessage) override;

    Y_FORCE_INLINE NRTYServer::TReply::TRTYStatus GetStatus() {
        return Status;
    }

    virtual void Reply() override;
};
