#include "sender_abstract.h"

#include <library/cpp/logger/global/global.h>

#include <saas/protos/rtyserver.pb.h>

#include <util/system/compiler.h>

namespace NRTYServer {
    IContext::TPtr ISender::Send(const TString& /*message*/, const TString& /*request*/) const {
        FAIL_LOG("Not implemented: 'Send(TString)'");
        ythrow yexception() << "Not implemented: " << Y_FUNC_SIGNATURE;
    }

    TInfoContext::TInfoContext(const NRTYServer::TMessage& message)
        : Url(message.GetDocument().GetUrl())
        , Id(message.GetMessageId())
    {
    }

    TString TInfoContext::BuildId() const {
        return "url=" + GetUrl() + ";id=" + ToString(GetId());
    }

    TString TInfoContext::BuildId(const NRTYServer::TMessage& message) {
        return "url=" + message.GetDocument().GetUrl() + ";id=" + ToString(message.GetMessageId());
    }
}

