#pragma once

#include <util/generic/ptr.h>
#include <util/datetime/base.h>

namespace NRTYServer {

    class TMessage;
    class TReply;

    class IContext {
    public:
        typedef TAtomicSharedPtr<IContext> TPtr;

    public:
        virtual ~IContext() = default;

        virtual void Cancel() {
        }
    };

    class ISender {
    public:
        typedef TAtomicSharedPtr<ISender> TPtr;

    public:
        virtual ~ISender() = default;

        virtual IContext::TPtr Send(const TString& /*message*/, const TString& /*request*/) const;
        virtual IContext::TPtr Send(const NRTYServer::TMessage& message, const TString& request="") const = 0;
        virtual bool Recv(IContext::TPtr context, NRTYServer::TReply& reply, TDuration timeout = TDuration::Zero()) const = 0;
    };

    class TInfoContext: public IContext {
    private:
        TString Url;
        ui64 Id;
    public:
        explicit TInfoContext(const NRTYServer::TMessage& message);

        TInfoContext(const TString& url, const ui64 id)
            : Url(url)
            , Id(id)
        {
        }

        const TString& GetUrl() const {
            return Url;
        }

        ui64 GetId() const {
            return Id;
        }

        TString BuildId() const;

        static TString BuildId(const NRTYServer::TMessage& message);
    };
};
