#pragma once

#include "sender_abstract.h"
#include <saas/library/sender_neh/sender_neh.h>

namespace NRTYServer {

    class TNehContext: public TInfoContext {
    private:
        NNeh::THandleRef Handle;

    public:
        TNehContext(NNeh::THandleRef handle, const NRTYServer::TMessage& message);
        ~TNehContext() override;

        NNeh::THandleRef& GetHandle() {
            return Handle;
        }

        virtual void Cancel() override;
    };

    class TNehSender: public ISender {
    private:
        const TString Address;
        const TString Protocol;
        mutable NNeh::TServiceStatRef Stat;

    public:
        TNehSender(const TString& protocol, const TString& host, const ui16 port);
        TNehSender(const TString& host, const ui16 port);
        ~TNehSender() override;

        using ISender::Send;
        virtual IContext::TPtr Send(const NRTYServer::TMessage& message, const TString& request = Default<TString>()) const override;
        virtual bool Recv(IContext::TPtr context, NRTYServer::TReply& reply, TDuration timeout) const override;
    };

};
