#pragma once

#include <util/generic/fwd.h>
#include <util/generic/ptr.h>

class TFileMap;

namespace NRTYServer {
    /// Enables global writable mappings
    void EnableGlobalMapping(bool IsReadOnly = false);

    /// Tries to get get shared mapping first
    THolder<TFileMap> GetFileMapping(const TString& filename);

    /// Avoid using global mappings
    THolder<TFileMap> GetTempFileMapping(const TString& filename, bool isReadOnly);

    /// Release global mapping
    void ReleaseFileMapping(const TString& filename);

    inline THolder<TFileMap> GetFileMapping(bool useGlobal, const TString& filename, bool isReadOnly=false) {
        return useGlobal ? GetFileMapping(filename) : GetTempFileMapping(filename, isReadOnly);
    }
}
