#pragma once

#include <util/generic/string.h>
#include <util/generic/set.h>

const TSet<TString> RTYMetaCgiParamsToBase = {
    "au",
    "auproto",
    "bu",
    "buproto",
    "efacets",
    "gafacets",
    "facets",
    "nofacet",
    "forcefacet",
    "facetprefix",
    "facetsfb",
    "qs_req",
    "sums",
    "borders",
    "sgkps",
    "component",
    "rty_hits_count",
    "rty_hits_detail",
    "delay",
    "key_name",
    "normal_kv_report",
    "regexp_ignore_case",
    "sleep",
    "comp_search",
    "regexp"
};

const TSet<TString> RTYMetaCgiParamsForHash = {
    "fsgta",
};

const TSet<TString> RTYMetaCgiParamsToBackend = {
    "ag0",
    "raId",
    "uuid",
    "strictsyntax",
    "keepjoins",
    "queryId",
    "service",
    "meta_search",
    "metaservice",
    "instant"
};

const TSet<TString> RTYMetaCgiParamsToService = {
    "wizextra",
    "restrict",
    "template",
    "msp",
    "rwr",
    "sp_meta_search",
    "skip-wizard",
    "lr",
    "vhost" //todo: special ymusic param, remove it after customization?
};

class TRTYMetaCgiParams {
private:
    TSet<TString> ToBase;
    TSet<TString> ToBackend;
    TSet<TString> ToService;
    TSet<TString> ForHash;
public:
    TRTYMetaCgiParams()
        : ToBase(RTYMetaCgiParamsToBase)
        , ToBackend(RTYMetaCgiParamsToBackend)
        , ToService(RTYMetaCgiParamsToService)
        , ForHash(RTYMetaCgiParamsForHash)
    {
        ToBackend.insert(ToBase.begin(), ToBase.end());
        ToService.insert(ToBackend.begin(), ToBackend.end());
        ForHash.insert(ToBase.begin(), ToBase.end());
    }

    static const TSet<TString>& GetParamsToBase() {
        return Singleton<TRTYMetaCgiParams>()->ToBase;
    }
    static const TSet<TString>& GetParamsToBackend() {
        return Singleton<TRTYMetaCgiParams>()->ToBackend;
    }
    static const TSet<TString>& GetParamsToService() {
        return Singleton<TRTYMetaCgiParams>()->ToService;
    }

    static const TSet<TString>& GetParamsForHash() {
        return Singleton<TRTYMetaCgiParams>()->ForHash;
    }
};
