#include "config.h"
#include <library/cpp/mediator/global_notifications/system_status.h>

#include <search/config/virthost.h>

namespace NSimpleMeta {
    static const TStringBuf DefaultConnStatOptions = "FailThreshold=10000, CheckTimeout=30s, CheckInterval=1000";

    void TConfig::InitFromSection(const TYandexConfig::Section* section, const TString& eventLogNameFromTemplate) {
        const TYandexConfig::Directives& directives = section->GetDirectives();

        ConnectTimeout = TDuration::MilliSeconds(directives.Value<ui32>("TimeoutConnectms", ConnectTimeout.MilliSeconds()));
        SendingTimeout = TDuration::MilliSeconds(directives.Value<ui32>("TimeoutSendingms", SendingTimeout.MilliSeconds()));
        GlobalTimeout = TDuration::MilliSeconds(directives.Value<ui32>("GlobalTimeout", GlobalTimeout.MilliSeconds()));
        TasksCheckInterval = TDuration::MilliSeconds(directives.Value<ui32>("TasksCheckIntervalms", TasksCheckInterval.MilliSeconds()));

        directives.GetValue("AllowDynamicWeights", AllowDynamicWeights);
        directives.GetValue("LoggingEnabled", LoggingEnabled);
        directives.GetValue("ParallelRequestCount", ParallelRequestCount);
        directives.GetValue("ThreadsSenders", ThreadsSenders);
        directives.GetValue("MaxAttempts", MaxAttempts);
        directives.GetValue("MaxKeysPerRequest", MaxKeysPerRequest);
        directives.GetValue("MaxQueueSize", MaxQueueSize);
        directives.GetValue("EventLog", EventLogPath);
        directives.GetValue("EventLogCompressionFormat", EventLogCompressionFormat);
        directives.GetValue("ReqAnsEnabled", ReqAnsEnabled);
        directives.GetValue("EventLogEnabled", EventLogEnabled);
        directives.GetValue("RouteHashType", RouteHashType);
        directives.GetValue("SourceTimeoutFactor", SourceTimeoutFactor);
        directives.GetValue("ThreadsStatusChecker", ThreadsStatusChecker);
        directives.GetValue("PrechargeSourceConnections", PrechargeSourceConnections);
        directives.GetValue("HedgedRequestTimeoutMs", HedgedRequestTimeoutMs);
        directives.GetValue("HedgedRequestRateThreshold", HedgedRequestRateThreshold);
        directives.GetValue("HedgedRequestRateSmooth", HedgedRequestRateSmooth);
        directives.GetValue("HedgedRequestTimeoutsRange", HedgedRequestTimeoutsRange);
        AssertCorrectConfig(ThreadsStatusChecker == 1, "Only one checker thread supported now");
        EventLogPathFromTemplate = eventLogNameFromTemplate;

        TString connStatOptionsStr;
        if (!directives.GetValue("ConnStatOptions", connStatOptionsStr)) {
            connStatOptionsStr = DefaultConnStatOptions;
        }
        if (connStatOptionsStr.empty()) {
            ConnStatOptions.Drop();
        } else {
            TConnStatOptions parser;
            try {
                parser.Parse(connStatOptionsStr);
                ConnStatOptions = MakeSimpleShared<NScatter::TConnStatOptions>(static_cast<const NScatter::TConnStatOptions&>(parser));
            } catch (...) {
                auto error = CurrentExceptionMessage();
                AbortFromCorruptedConfig("Can not parse ConnStatOptions: %s", error.data());
            }
        }
    }
}

