#pragma once

#include <optional>
#include <util/generic/string.h>

namespace NSaasLB {
    struct TTopicInfo {
        TString Cluster;
        TString Directory;
        TString Name;
        ui32 Partition;
    };

    template <class TValue, class TProperty>
    TValue GetPropertyValue(const TProperty& property) {
        return property.has_user_defined() ? property.user_defined() : property.default_();
    }

    TString GetLogbrokerToken();
    std::optional<TString> GetLogbrokerRemoteMirrorRulesToken();
    std::optional<TTopicInfo> GetTopicInfo(const TString& topic);
    TString MaskToken(const TString& token);
}
