from util.generic.string cimport TString

from six import PY3

cdef _to_py_str(const TString& str):
    binary = str.c_str()[:str.length()]
    if PY3 and hasattr(binary, 'decode'):
        return binary.decode('utf-8')
    return binary

cdef extern from "saas/library/persqueue/configuration/proto/types.pb.h" namespace "NSaasLB" nogil:
    ctypedef enum ELogbrokerName 'NSaasLB::ELogbrokerName':
        pass

cdef extern from "saas/library/persqueue/common/installations.h" namespace "NSaasLB" nogil:
    cdef TString FormatLogbrokerName(ELogbrokerName logbroker) except +
    cdef TString GetLogbrokerEndpoint(ELogbrokerName logbroker) except +
    cdef TString GetLogbrokerEndpointWithPort(ELogbrokerName logbroker) except +
    cdef TString GetCMLogbrokerEndpointWithPort(ELogbrokerName logbroker) except +
    cdef TString GetYtDeliveryPath(ELogbrokerName logbroker) except +

def format_logbroker_name(ELogbrokerName logbroker):
    return _to_py_str(FormatLogbrokerName(logbroker))

def get_endpoint(ELogbrokerName logbroker):
    return _to_py_str(GetLogbrokerEndpoint(logbroker))

def get_endpoint_with_port(ELogbrokerName logbroker):
    return _to_py_str(GetLogbrokerEndpointWithPort(logbroker))

def get_cm_endpoint_with_port(ELogbrokerName logbroker):
    return _to_py_str(GetCMLogbrokerEndpointWithPort(logbroker))

def get_yt_delivery_path(ELogbrokerName logbroker):
    return _to_py_str(GetYtDeliveryPath(logbroker))
