#pragma once

#include <logbroker/public/api/grpc/config_manager.grpc.pb.h>

#include <util/generic/vector.h>

namespace NSaasLB {
    class TRequestProcessor;

    class TLogbrokerApi {
    private:
        std::shared_ptr<TRequestProcessor> RequestProcessor;
        const TString Token;
    public:
        TLogbrokerApi(const TString& server, const TString& token);

        NLogBroker::ListAccountsResult GetAccountsList();
        NLogBroker::ListYtDeliveriesResult GetYtDeliveriesList();
        NLogBroker::ListDirectoryResult ListDirectory(const TString& path);
        NLogBroker::DescribePathResult DescribePath(const TString& path);
        TVector<NLogBroker::ExecuteModifyCommandsResult> ExecuteModifyCommands(
            const TVector<NLogBroker::SingleModifyRequest>& commands,
            const TString& comment
        );
    };
}
