#pragma once

#include <saas/library/persqueue/configuration/proto/types.pb.h>
#include <saas/library/persqueue/configuration/proto/description.pb.h>
#include <saas/library/persqueue/configuration/service/modify_manager/proto/changes.pb.h>

#include <library/cpp/zookeeper/zookeeper.h>

namespace NSaasLB {

    const TString MAIN_SAAS_ZK_CLUSTER = "saas-zookeeper1.search.yandex.net:14880,saas-zookeeper2.search.yandex.net:14880,saas-zookeeper3.search.yandex.net:14880,saas-zookeeper4.search.yandex.net:14880,saas-zookeeper5.search.yandex.net:14880";

    class TNamespaceManager {
    public:
        TNamespaceManager();
        TNamespaceManager(const TString& ns);
        void Create(const TString& name, const TNamespaceConfig& config);
        void Modify(const TNamespaceConfig& config);
        void Remove();

        void Apply();
        TNamespaceModifyRequest GetChanges() const;

        static TString GetNamespaceConfigPath(const TString& name);

        const TString& GetName() const;
        const TNamespaceConfig& GetConfig() const;
        TNamespaceDescription Describe() const;

        TServiceConfig CreateServiceConfig(
            const TString& serviceName,
            const TString& ctype,
            ELogbrokerName logbroker,
            const TVector<EDataCenter>& dataCenters,
            const TVector<TString>& ytDeliveryClusters,
            std::optional<ELogbrokerName> logbrokerMirror,
            std::optional<TString> topicsPath,
            std::optional<TString> mirrorTopicsPath,
            std::optional<TString> consumersPath,
            std::optional<TString> mirrorConsumersPath,
            std::optional<TString> locksPath,
            std::optional<TString> deployManagerHost,
            std::optional<TVector<TString>> gencfgGroups
        ) const;

    private:
        void InitStorage();

        void LoadConfig();
        void SaveConfig();
        void RemoveConfig();

    private:
        TString Namespace;
        TString NamespaceConfigPath;
        std::optional<TNamespaceConfig> Config;

        THolder<NZooKeeper::TZooKeeper> Storage;
        std::optional<TNamespaceModifyRequest> ChangeRequest;
    };
}
