from util.generic.string cimport TString
from libcpp cimport bool

import logging

cdef extern from "library/cpp/logger/global/global.h" nogil:
    void DoInitGlobalLog(const TString& logType, const int logLevel, const bool rotation, const bool startAsDaemon);

cdef int _from_python_log_level(int level):
    if level == logging.CRITICAL:
        return 2 # TLOG_CRIT
    elif level == logging.ERROR:
        return 3 # TLOG_ERR
    elif level == logging.WARNING:
        return 4 # TLOG_WARNING
    elif level == logging.INFO:
        return 6 # TLOG_INFO
    else:
        return 8 # TLOG_RESOURCES


def init(TString logfile, loglevel):
    cdef int c_loglevel = _from_python_log_level(loglevel)
    with nogil:
        DoInitGlobalLog(logfile, c_loglevel, False, False)
