from util.generic.string cimport TString
from util.generic.vector cimport TVector
from util.system.types cimport ui32

from six import PY3


cdef extern from '<optional>' namespace 'std' nogil:
    cdef cppclass optional[T]:
        optional()
        optional(T) except +
        T& value() except +

cdef TString _to_string(s):
    if s is None or len(s) == 0:
        return TString()
    elif PY3 and hasattr(s, 'encode') or isinstance(s, unicode):
        s = s.encode('utf-8')
    return TString(<const char*>s, len(s))

cdef _to_py_str(const TString& str):
    binary = str.c_str()[:str.length()]
    if PY3 and hasattr(binary, 'decode'):
        return binary.decode('utf-8')
    return binary

cdef TVector[TString] _to_strings_vector(py_arr):
    cdef TVector[TString] result
    for item in py_arr:
        result.push_back(_to_string(item))
    return result

cdef TVector[ui32] _to_ui32_vector(py_arr):
    cdef TVector[ui32] result
    for item in py_arr:
        result.push_back(item)
    return result
