#pragma once

#include <logbroker/public/api/grpc/config_manager.grpc.pb.h>

#include <util/generic/hash.h>
#include <util/generic/set.h>
#include <util/string/vector.h>

namespace NSaasLB {
    class TYtDeliveryStorage {
    public:
        void InitDeliveries(const TVector<TString>& deliveries);

        std::optional<NLogBroker::SingleModifyRequest> Add(const TString& topicPath, const TString& delivery);
        std::optional<NLogBroker::SingleModifyRequest> Remove(const TString& topicPath, const TString& delivery);

        bool Exist(const TString& topicPath, const TString& delivery) const;
        TVector<TString> GetFor(const TString& topicPath) const;

        void Load(const TString& topicPath, const NLogBroker::DescribeTopicResult& topicDescription);

    private:
        void CheckDeliveryName(const TString& delivery) const;

    private:
        TSet<TString> AvailableDeliveries;
        THashMap<TString, TSet<TString>> Deliveries;
    };
}
