#pragma once

#include <saas/library/persqueue/configuration/service/modify_manager/proto/changes.pb.h>
#include <saas/library/persqueue/configuration/service/modify_manager/components.h>

#include <util/generic/hash_set.h>
#include <util/generic/hash.h>

namespace NZooKeeper {
    class TZooKeeper;
}

namespace NSaasLB {

    class TServiceMetaManager : public IComponent<TServiceMetaModifyRequests> {
    public:
        TServiceMetaManager(const TString& ns, const TString& name, const TString& ctype);
        ~TServiceMetaManager();

        void TryLoadServiceConfig();
        const TServiceConfig& GetConfig() const;

        void SetConfig(const TServiceConfig& config);
        void Remove();

        const TServiceMetaModifyRequests& GetChanges() const override;
        void Apply(ui32 changesCount) override;

    private:
        void AddChange(EChangeAction action, std::optional<TServiceConfig> config);

        void RecursiveCreateNode(const TString& nodePath, const TString& data);
        void RemoveNode(const TString& nodePath);

    private:
        const TString Namespace;
        const TString Name;
        const TString Ctype;

        THolder<NZooKeeper::TZooKeeper> Storage;
        TString ServiceConfigPath;

        std::optional<TServiceConfig> Config;
        TServiceMetaModifyRequests Changes;
    };

}
