#pragma once

#include <saas/library/zk/zk.h>


namespace NSaasLB {
    class TConsumerLocker : public NSaas::TZKClient {
    private:
        TString Path;
        TString Topic;
        TString EntityId;
        TString LockedConsumer;
        bool UseNewLBProtocol = false;

    private:
        TString DecodeConsumer(const TString& path) const;
        TString EncodeTopic(const TString& path) const;

    public:
        TConsumerLocker(
            const TString& servers,
            const TString& path,
            const TString& topic,
            const TString& entityId,
            std::function<void()> connectionLostCallback,
            ui32 maxAttempts = 3,
            TDuration waitTime = TDuration::Minutes(5)
        );
        ~TConsumerLocker();

        TString LockFreeConsumer();
        void Release();
    };
}
