#pragma once

#include <library/cpp/logger/global/global.h>

namespace NSaas {
    template <class ILogger>
    class TPersQueueLogger : public ILogger
    {
    public:
        TPersQueueLogger(TLog& log)
            : Logger(log)
            , Level(static_cast<int>(Logger.FiltrationLevel()))
        {
        }

        TPersQueueLogger(const TString& file, int level = static_cast<int>(LOG_MAX_PRIORITY))
            : LoggerPtr(new TLog(file))
            , Logger(*LoggerPtr)
            , Level(level)
        {
        }

        void Log(const TString& msg, const TString& sourceId, const TString& sessionId, int level) override {
            if (!IsEnabled(level)) return;
            Logger << TInstant::Now().ToStringLocal() << " sourceId: " << sourceId << " sessionId: " << sessionId << " : " << msg << "\n";
        }

        bool IsEnabled(int level) const override {
            return level <= Level;
        }

    private:
        THolder<TLog> LoggerPtr;
        TLog& Logger;
        const int Level;
    };
}
