#pragma once

#include <saas/library/persqueue/writer/writer.h>
#include <kikimr/persqueue/sdk/deprecated/cpp/v2/logger.h>

#include <Python.h>

namespace NSaas {
    using TCWriteCallback = void (*)(PyObject* future, const NThreading::TFuture<TPersQueueWriter::TWriteResult>& cfuture);
    using TWriteCallback = std::function<void (const NThreading::TFuture<TPersQueueWriter::TWriteResult>& cfuture)>;

    TWriteCallback MakeWriteCallback(TCWriteCallback callback, PyObject* future);

    using TPyLoggerCallback = void (*)(PyObject*, const TString &msg, const TString& sourceId, const TString& sessionId, int level);

    class TPythonLogger : public NPersQueue::ILogger {
    public:
        TPythonLogger(TPyLoggerCallback callback, PyObject* object, int logLevel);
        void Log(const TString& msg, const TString& sourceId, const TString& sessionId, int level) override;
        bool IsEnabled(int level) const override;

    private:
        const TPyLoggerCallback Callback;
        const std::shared_ptr<PyObject> Object;
        const int LogLevel = 0;
    };
}
