#pragma once

#include <saas/api/action.h>
#include <saas/library/sharding/sharding.h>
#include <saas/library/searchmap/searchmap.h>

#include <library/cpp/yconf/conf.h>

#include <util/folder/path.h>
#include <util/generic/set.h>

namespace NSaas {

struct TSearchMapInputSettings {
    TString Ctype;
    ui16 DMPort = 80;
    TString DMHost;

    ui16 StaticaPort = 80;
    TString StaticaHost;
    TString StaticaQuery;

    TString File;

    TDuration UpdatePeriod = TDuration::Zero(); // zero - searchmap won't be updated after first initialization

    void Init(TYandexConfig::Section* section);
    void Print(IOutputStream& so) const;
};

NSearchMapParser::TSearchMap GetSearchMap(const TSearchMapInputSettings& searchMapSettings, const TSet<TString>& filterServices);

class TServiceShards {
public:
    void Init(const TSearchMapInputSettings& searchMapSettings, const TString& service, bool ignorIndexDisabledSlots = true);
    void Init(const NSearchMapParser::TSearchMap& searchMap, const TString& service, bool ignorIndexDisabledSlots = true);
    void Init(const TString& searchMapString, const TString& service, bool ignorIndexDisabledSlots = true);
    void Init(const TVector<NSearchMapParser::TShardsInterval>& shards, const TShardsDispatcher::TContext& dispatching);
    bool Initilized() const;

    TShardsDispatcher::TPtr GetShardsDispatcher() const;
    TVector<NSearchMapParser::TShardsInterval> GetShards() const;

    TVector<NSearchMapParser::TShardsInterval> GetShards(const NRTYServer::TMessage& message) const;
    TVector<NSearchMapParser::TShardsInterval> GetShards(const NSaas::TAction& action) const;
private:
    void FillShards(const NSearchMapParser::TSearchMapService* config, bool ignorIndexDisabledSlots);
    bool IsBroadcast(const NRTYServer::TMessage& message) const;
protected:
    TShardsDispatcher::TPtr ShardsDispatcher;
    TVector<NSearchMapParser::TShardsInterval> Shards;
};

}
