from .tag import GencfgTag
from typing import Any, Optional, Callable, AnyStr, Union, List, Dict
from logging import Logger

class GencfgAPI:
    BASE_URL: str
    DEFAULT_HEADERS: Dict[AnyStr, Union[AnyStr, int]]
    LOGGER: Logger

    def __init__(self, debug: bool, tag: Optional[Union[GencfgTag, AnyStr]], wait_function: Callable): ...

    # noinspection PyPropertyDefinition
    @property
    def api_url(self) -> AnyStr: ...

    # noinspection PyPropertyDefinition
    @property
    def tag(self) -> GencfgTag: ...

    @tag.setter
    def tag(self, tag: Union[GencfgTag, AnyStr]) -> None: ...

    @classmethod
    def get_tags(cls) -> List[GencfgTag]: ...

    @classmethod
    def get_tag_by_commit(cls, commit: int) -> GencfgTag: ...

    @classmethod
    def wait_for_tag_with_commit(cls, commit: int) -> GencfgTag: ...

    @classmethod
    def wait_for_tag_with_groups(cls, groups: AnyStr) -> GencfgTag: ...

    @classmethod
    def get_latest_tag(cls) -> GencfgTag: ...

    @classmethod
    def group_present_in_trunk(cls, group: AnyStr) -> bool: ...

    @classmethod
    def group_present_in_tag(cls, group: AnyStr, tag: Union[GencfgTag, AnyStr]): ...

    def get_groups_by_hostlist(self, host_list: List[AnyStr]) -> List[AnyStr]: ...

    def group_exists(self, group: AnyStr) -> bool: ...

    def get_group_info(self, group: AnyStr, sub_path: str = '') -> Dict[AnyStr, Union[AnyStr,List[AnyStr]]]: ...

    def get_group_info_card(self, group: AnyStr) -> Dict[AnyStr, Any]: ...

    def get_group_hostlist(self, group: AnyStr) -> List[AnyStr]: ...

    def get_slave_groups(self, group: AnyStr) -> List[AnyStr]: ...

    def get_hosts_data(self, hosts: List[AnyStr]) -> Dict[AnyStr, List[Dict[AnyStr, Any]]]: ...

    def get_instances(self, group: AnyStr) -> List[Dict[AnyStr, Any]]: ...

    def get_memory_guarantee(self, group: AnyStr) -> float: ...

    def get_memory_limit(self, group: AnyStr) -> float: ...
