# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals


class GencfgApiError(Exception):
    """Basic exception for gencfg api errors"""
    def __init__(self, gencfg_response=None, *args, **kwargs):
        super(GencfgApiError, self).__init__(*args, **kwargs)
        if gencfg_response is not None:
            self.url = gencfg_response.url
            self.code = gencfg_response.status_code
            self.gencfg_response = gencfg_response
            self.message = 'Request to gencfg api url "{}" failed with http code: {}'.format(self.url, self.code)


class GencfgGroupNotFound(GencfgApiError):
    """Raised if requested group not exists in tag"""
    def __init__(self, group, tag, *args, **kwargs):
        super(GencfgGroupNotFound, self).__init__(*args, **kwargs)
        self.group = group
        self.tag = tag
        self.message = 'Gencfg group(s) "{}" not present in tag {}'.format(self.group, self.tag)


class InvalidTag(ValueError):
    """Raised for invalid tags"""
