from .tag import GencfgTag
from typing import Any, AnyStr, Optional, Pattern, Union, List, Dict
from logging import Logger

GENCFG_GROUPS_LOCATIONS: Any

class GencfgGroup:
    LOGGER: Logger = ...
    REGEXP_IO_LIMIT: Pattern = ...
    REGEXP_GROUP_GEO: Pattern = ...
    def __init__(self, name: AnyStr, tag: Optional[Union[GencfgTag, AnyStr]], validate: bool = True): ...

    def __eq__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...

    @classmethod
    def from_str(cls, name_with_tag: AnyStr) -> GencfgGroup: ...

    @classmethod
    def list_from_str(cls, names_with_tags: AnyStr) -> List[GencfgGroup]: ...

    # noinspection PyPropertyDefinition
    @property
    def name(self) -> AnyStr: ...

    # noinspection PyPropertyDefinition
    @property
    def tag(self) -> GencfgTag: ...
    @tag.setter
    def tag(self, value: Union[GencfgTag, AnyStr]): ...

    # noinspection PyPropertyDefinition
    @property
    def card(self) -> Dict[AnyStr, Any]: ...

    # noinspection PyPropertyDefinition
    @property
    def io_limits(self) -> Dict[AnyStr, int]: ...

    # noinspection PyPropertyDefinition
    @property
    def prj_tags(self) -> List[AnyStr]: ...

    # noinspection PyPropertyDefinition
    @property
    def location(self) -> AnyStr: ...

    # noinspection PyPropertyDefinition
    @property
    def hosts(self) -> List[AnyStr]: ...
