import abc
import grpc

from typing import Mapping, List, Union, Tuple, Callable, Any
from saas.library.python.logbroker.client import TService, TServiceClass
from saas.library.python.logbroker.common import LogbrokerEndpoint

class GRPCClient(metaclass=abc.ABCMeta):
    _CONNECT_OPTIONS: List[Tuple[str, Union[int, str]]] = ...
    _TIMEOUT: int = ...

    @classmethod
    def _get_grpc_channel(cls, endpoint: str) -> grpc.Channel: ...

class LogbrokerClient(GRPCClient, metaclass=abc.ABCMeta):
    _CM_LOGBROKER_ENDPOINT: LogbrokerEndpoint = ...
    _PROTO_MAPPING: Mapping[str, Callable] = ...
    _REQUEST_CHECK_DELAY: int = ...
    _REQUEST_CHECK_MAX_ATTEMPTS: int = ...

    def __init__(self, token: str=None, endpoint: LogbrokerEndpoint = _CM_LOGBROKER_ENDPOINT) -> None:
        self._token: str = ...
        self._endpoint: LogbrokerEndpoint = ...

    @classmethod
    async def _wrap_async(cls, sync_func: Callable) -> Any: ...

    @property
    @abc.abstractmethod
    def _service_stub_cls(self) -> TServiceClass: ...

    @property
    def _service_stub(self) -> TService: ...

    async def __get_response_data(self, service: TService, response: Any, attempt: int = 0) -> Any: ...

    async def _make_request(self, handle_name: str, **kwargs) -> Any: ...

class LogbrokerAPIException(Exception):
    ...
